/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ContainerChest;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;

public class LOTRTileEntityChest
extends TileEntity
implements IInventory {
    private ItemStack[] chestContents = new ItemStack[this.inventorySize];
    private int inventorySize = 27;
    public float lidAngle;
    public float prevLidAngle;
    public String textureName;
    private int numPlayersUsing;
    private int ticksSinceSync;
    private String customName;

    public void setInventorySize(int size) {
        this.inventorySize = size;
        this.chestContents = new ItemStack[size];
    }

    public int func_70302_i_() {
        return this.inventorySize;
    }

    public ItemStack func_70301_a(int i) {
        return this.chestContents[i];
    }

    public ItemStack func_70298_a(int i, int j) {
        if (this.chestContents[i] != null) {
            if (this.chestContents[i].field_77994_a <= j) {
                ItemStack itemstack = this.chestContents[i];
                this.chestContents[i] = null;
                this.func_70296_d();
                return itemstack;
            }
            ItemStack itemstack = this.chestContents[i].func_77979_a(j);
            if (this.chestContents[i].field_77994_a == 0) {
                this.chestContents[i] = null;
            }
            this.func_70296_d();
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70304_b(int i) {
        if (this.chestContents[i] != null) {
            ItemStack itemstack = this.chestContents[i];
            this.chestContents[i] = null;
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.chestContents[i] = itemstack;
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
        this.func_70296_d();
    }

    public String func_145825_b() {
        return this.func_145818_k_() ? this.customName : "container.chest";
    }

    public boolean func_145818_k_() {
        return this.customName != null && !this.customName.isEmpty();
    }

    public void setCustomName(String name) {
        this.customName = name;
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("InventorySize", this.inventorySize);
        NBTTagList itemTags = new NBTTagList();
        for (int i = 0; i < this.chestContents.length; ++i) {
            if (this.chestContents[i] == null) continue;
            NBTTagCompound slotData = new NBTTagCompound();
            slotData.func_74774_a("Slot", (byte)i);
            this.chestContents[i].func_77955_b(slotData);
            itemTags.func_74742_a((NBTBase)slotData);
        }
        nbt.func_74782_a("Items", (NBTBase)itemTags);
        if (this.func_145818_k_()) {
            nbt.func_74778_a("CustomName", this.customName);
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_74764_b("InventorySize")) {
            this.setInventorySize(nbt.func_74762_e("InventorySize"));
        }
        NBTTagList itemTags = nbt.func_150295_c("Items", 10);
        this.chestContents = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < itemTags.func_74745_c(); ++i) {
            NBTTagCompound slotData = itemTags.func_150305_b(i);
            int slot = slotData.func_74771_c("Slot") & 0xFF;
            if (slot < 0 || slot >= this.chestContents.length) continue;
            this.chestContents[slot] = ItemStack.func_77949_a((NBTTagCompound)slotData);
        }
        if (nbt.func_150297_b("CustomName", 8)) {
            this.customName = nbt.func_74779_i("CustomName");
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this && player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_145845_h() {
        super.func_145845_h();
        this.prevLidAngle = this.lidAngle;
        ++this.ticksSinceSync;
        if (!this.field_145850_b.field_72995_K && this.numPlayersUsing != 0 && (this.ticksSinceSync + this.field_145851_c + this.field_145848_d + this.field_145849_e) % 200 == 0) {
            this.numPlayersUsing = 0;
            float range = 5.0f;
            List players = this.field_145850_b.func_72872_a(EntityPlayer.class, AxisAlignedBB.func_72330_a((double)((float)this.field_145851_c - range), (double)((float)this.field_145848_d - range), (double)((float)this.field_145849_e - range), (double)((float)(this.field_145851_c + 1) + range), (double)((float)(this.field_145848_d + 1) + range), (double)((float)(this.field_145849_e + 1) + range)));
            for (EntityPlayer player : players) {
                if (!(player.field_71070_bA instanceof ContainerChest) || ((ContainerChest)player.field_71070_bA).func_85151_d() != this) continue;
                ++this.numPlayersUsing;
            }
        }
        this.handleLidMovement();
    }

    private void handleLidMovement() {
        if (this.numPlayersUsing > 0 && this.lidAngle == 0.0f) {
            this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, "random.chestopen", 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
        }
        if (this.numPlayersUsing == 0 && this.lidAngle > 0.0f || this.numPlayersUsing > 0 && this.lidAngle < 1.0f) {
            float prev = this.lidAngle;
            this.lidAngle += this.numPlayersUsing > 0 ? 0.1f : -0.1f;
            this.lidAngle = Math.min(1.0f, Math.max(0.0f, this.lidAngle));
            if (this.lidAngle < 0.5f && prev >= 0.5f) {
                this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, "random.chestclosed", 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
        }
    }

    public void func_70295_k_() {
        ++this.numPlayersUsing;
        this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q(), 1, this.numPlayersUsing);
    }

    public void func_70305_f() {
        --this.numPlayersUsing;
        this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q(), 1, this.numPlayersUsing);
    }

    public boolean func_145842_c(int id, int value) {
        if (id == 1) {
            this.numPlayersUsing = value;
            return true;
        }
        return super.func_145842_c(id, value);
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return true;
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.func_145836_u();
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 1), (double)this.field_145848_d, (double)(this.field_145849_e - 1), (double)(this.field_145851_c + 2), (double)(this.field_145848_d + 2), (double)(this.field_145849_e + 2));
    }
}

